//
//  MCTableViewAnalyzer.h
//  MCApplication
//
//  Created by Alykhan Jetha on Sat Mar 29 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>
#import "MCModelEditor.h"


#define MCTVA_LABEL @"label"
#define MCTVA_COUNT @"labelCount"

@class MCTableviewController;

@interface MCTableViewAnalyzer : MCModelEditor {

	id			_tvcToAnalyze;
	id			_tableColumnToGroupBy;
	
	id			dateFormatPopup;
	id			columnPUC;
	
	id			chartTypePopup;
	
	id			sheetTitleField;
	id			chartTitleField;
	id			chartSubtitleField;
	
	BOOL		_currentColumnIsDate;
	NSString	*_columnSeparator;

}

+ (MCTableViewAnalyzer *)defaultTableViewAnalyzer;

- (void)setTVCToAnalyze:(MCTableviewController *)aTVC;

- (void)setTableColumnToAnalyze:(NSTableColumn *)aColumn;
- (NSTableColumn *)tableColumnToAnalyze;

- (IBAction)dateFormatChanged:(id)sender;

// for close button and esc key
- (IBAction)cancel:(id)sender;

- (IBAction)sendToChartsmith:(id)sender;

@end
